<?php 
  if( !hasPermission($_SESSION['user_detail']['role_id'], 'cash_receipt_list') ) {
    echo '<script>window.location.href="index.php?page=no_permission.php"</script>';
    die();
  }

  $bank = mysqli_query($conn, "SELECT * FROM `act_master` WHERE `account_group` ='CASH'");
  $bank_data = array();
  while ($bank_row = mysqli_fetch_assoc($bank)) {
    $bank_data[] = $bank_row;
  }

  $account = mysqli_query($conn, "SELECT * FROM `act_master`");
  $account_data = array();
  while ($account_row = mysqli_fetch_assoc($account)) {
    $account_data[] = $account_row;
  }
?> 
<section class="content-header">
  <div class="row">
      <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 bottom20">
        <h3 class="capital font15 padding5 bold">VIEW CASH RECEIPT DETAILS</h3>
      </div>
      <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 text-right bottom20">
        <h3>
          <?php if( hasPermission($_SESSION['user_detail']['role_id'], 'bank_receipt_add') ) { ?>
          <a href="index.php?page=cash_receipt/manage.php" class="btn cust-btn btn-danger bottom10 capital">Add New CASH RECEIPT</a>
          <button class="btn cust-btn btn-danger bottom10" data-toggle="modal" data-target="#search"><i class="fa fa-filter" aria-hidden="true"></i></button>
        <?php } ?>
        </h3>
      </div>
  </div>
</section>
<hr class="bottom35"> 
<section class="hitz-top-header">
  <div class="card bottom40">
    <div class="card-body table-responsive">
      <table id="example1" class="table table-bordered list_data width100">
        <thead>
          <tr>
            <th width="40">SR NO.</th>
            <th width="80">VOUCHER NO</th>
            <th width="70">DATE</th>
            <th width="150">BANK</th>
            <th>ACCOUNT NAME</th>
            <th width="70">AMOUNT</th>
            <th width="100">CREATED BY</th>
            <th width="90">ACTION</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td colspan="8"><?php echo "NO RECORD FOUND"; ?></td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>
</section>
<div class="modal right fade" id="search" role="dialog" aria-labelledby="myModalLabel2">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-body">
        <form method="post">
          <div class="col-md-12 top10" id="common-wrapper">
            <label>VOUCHER</label>
            <input type="text" name="voucher" id="voucher" class="form-control" autocomplete="off">
          </div>
          <div class="col-md-12 top10" id="common-wrapper">
            <label>CASH</label>
            <select class="form-control select2 required" name="bank" id="bank" style="width:100%">
              <option></option>
              <?php foreach ($bank_data as $key => $bank_datas) {
              echo '<option value="'. $bank_datas['id'] .'">' . $bank_datas['ac_name'] . '</option>';
              } ?>
            </select>
          </div>
          <div class="col-md-12 top10" id="common-wrapper">
            <label>ACCOUNT NAME</label>
            <select class="form-control select2 required" name="account_name" id="account_name" style="width:100%">
              <option></option>
              <?php foreach ($account_data as $key => $account_datas) {
              echo '<option value="'. $account_datas['id'] .'">' . $account_datas['ac_name'] . '</option>';
              } ?>
            </select>
          </div>
          
          <div class="col-md-12 top10">
            <button type="button" class="btn btn-danger capital bottom10 custome-btn top10" id="btn-genrate">SEARCH</button>
          </div>
        </form>   
      </div>
    </div>
  </div>
</div>
<script type="text/javascript">
jQuery(document).ready(function() {
  loadDataTable();
  jQuery('#bank').select2();
  jQuery('#account_name').select2();
  jQuery('#btn-genrate').click(function(){
    loadDataTable();
  });
});

function loadDataTable(){
    if(typeof dTable!='undefined'){dTable.fnDestroy();}

    dTable=jQuery('.list_data').dataTable({
        "bProcessing"       : true,
        "order"             : [ [0, 'desc'] ],
        "aLengthMenu"       : [ [5, 10, 15, 20, 25, 50, 100], [5, 10, 15, 20, 25, 50, 100] ],
        'iDisplayLength'    : "25",
        "aoColumns"         : [
             {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-left"}, {"sClass": "text-left"}, {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-center"}
        ],
        "bServerSide"       : true,
        "sAjaxSource"       : 'cash_receipt/fetch.php?p1=' + jQuery('#voucher').val() + '&p2=' + jQuery('#bank').val()+ '&p3=' + jQuery('#account_name').val(),
    });
}

function confirmDelete(e) {
  var $i = $(e).attr("id");
  console.log($i);
  swal({
      title: "Are you sure?",
      text: "You will not be able to recover this imaginary file!",
      type: "warning",
      showCancelButton: true,
      confirmButtonColor: "#DD6B55",
      confirmButtonText: "Yes, delete it!",
      closeOnConfirm: false
  }, function (isConfirm) {
      if (!isConfirm) return;
      $.ajax({
          url: "cash_receipt/delete.php",
          type: "POST",
          data: 'delete='+$i,
          dataType: "json",
          success: function () {
            swal({title: "Deleted!", text: "Data successfully Deleted!", type: "success"},
              function(){ 
                location.reload();
              }
            );
          },

          error: function (xhr, ajaxOptions, thrownError) {
            swal("Error deleting!", "Please try again", "error");
          }
      });
  });
}
</script>
