<?php
  if( !hasPermission($_SESSION['user_detail']['role_id'], 'bank_payment_add') ) {
    echo '<script>window.location.href="index.php?page=no_permission.php"</script>';die();
  }

   $bank = mysqli_query($conn, "SELECT * FROM `act_master` WHERE `account_group` ='BANK'");
   $bank_data = array();
   while ($bank_row = mysqli_fetch_assoc($bank)) {
      $bank_data[] = $bank_row;
   }

   $account = mysqli_query($conn, "SELECT * FROM `act_master`");
   $account_data = array();
   while ($account_row = mysqli_fetch_assoc($account)) {
      $account_data[] = $account_row;
   }

   if (isset($_REQUEST['p1']) && !empty($_REQUEST['p1'])){
      $select = mysqli_query($conn, "SELECT * FROM `bank_master` WHERE `id` = '".$_REQUEST['p1']."'");
      $rows = mysqli_fetch_assoc($select);
      $id               = $rows['id'];
      $code             = $rows['voucher'];
      $date             = $rows['date'];
      $bank_book        = $rows['bank_book'];
      $transaction_ty   = $rows['transaction_type'];
      $transaction_ref  = $rows['transaction_ref'];
      $remark           = $rows['remark'];
      $amount           = $rows['amount'];


      $query = mysqli_query($conn, "SELECT * FROM `bank_details` WHERE `master_id` = '".$id."' ORDER BY id ASC");
      $detail = array();
      while ($row = mysqli_fetch_assoc($query)) {
         $detail[] = $row;
      }
      
   }else{
      $id    = '';
      $code  = bpCode($conn);
   }
?>
<section class="content-header">
  <div class="row">
      <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 bottom20">
        <h3 class="capital font15 padding5 bold"><?php echo ($id == 0) ? 'ADD NEW BANK PAYMENT' : 'EDIT BANK PAYMENT'; ?></h3>
      </div>
      <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 text-right bottom20">
        <h3>
          <?php if( hasPermission($_SESSION['user_detail']['role_id'], 'bank_payment_list') ) { ?>
          <a href="index.php?page=bank_payment/list.php" class="btn btn-danger capital bottom10 custome-btn">VIEW BANK PAYMENT DETAILS</a>
          <?php } ?>
        </h3>
      </div>
  </div>
</section>
<hr class="bottom35"> 
<section class="hitz-top-header">
   <div class="row bottom40">
      <div class="col-xs-12">
         <div class="box box-success">
            <div class="box-body">
               <form action="bank_payment/insert.php" method="post" enctype="multipart/form-data" class="common-frm-validation" id="signupForm">
                  <div class="row">
                     <div class="col-md-12">
                        <div class="col-md-1">
                           <div class="form-group">
                              <label class="capital">VOUCHER NO</label><span class="error">*</span>
                              <input type="text" size="35" id="voucher_no" name="voucher_no" class="form-control" autocomplete="off" placeholder="VOUCHER NO" value="<?php echo $code;?>" readonly="" autofocus=""/>
                           </div>
                        </div>
                        <div class="col-md-2">
                           <div class="form-group">
                              <label class="capital">DATE</label><span class="error">*</span>
                              <div class="input-group">
                                 <input type="text" name="date" id="date" class="form-control date-picker required" autocomplete="off" value="<?php echo risFormatDate($date);?>"/>
                                 <div class="input-group-addon">
                                    <i class="fa fa-calendar date-icon-color"></i>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="row">
                     <div class="col-md-12">
                        <div class="col-sm-6">
                           <div class="form-group">
                              <label class="capital">BANK BOOK</label><span class="error">*</span>
                              <select class="form-control select2 required" name="bank" id="bank">
                                 <option></option>
                                 <?php foreach ($bank_data as $key => $bank_datas) {
                                    echo '<option value="'. $bank_datas['id'] .'" '. ($bank_datas['id'] == $bank_book ? 'selected' : '') .'>' . $bank_datas['ac_name'] . '</option>';
                                    } ?>
                              </select>
                           </div>
                        </div>
                     </div>
                     <div class="col-md-12">
                        <div class="col-md-3">
                           <div class="form-group">
                              <label class="capital">TRANSACTION TYPE</label><span class="error">*</span>
                              <select class="form-control required select2 transaction_type" name="transaction_type" id="transaction_type">
                                 <option value></option>
                                 <?php 
                                    foreach ($transaction_type as $transaction_types) {
                                    echo '<option value="'. $transaction_types .'" '. ($transaction_types == $transaction_ty ? 'selected' : '').'>'.$transaction_types.'</option>';
                                    } ?>
                              </select>
                           </div>
                        </div>
                        <div class="col-md-3">
                           <div class="form-group">
                              <label class="capital">INSTRUMENT NO</label><span class="error">*</span>
                              <input type="text" name="instrument_no" id="instrument_no" class="form-control required" placeholder="INSTRUMENT NO" value="<?php echo $transaction_ref ?>">
                           </div>
                        </div>
                     </div>
                     <div class="col-md-12">
                        <div class="col-md-3">
                           <div class="form-group">
                              <label class="capital">TOTAL AMOUNT</label><span class="error">*</span>
                              <input type="text" name="total_amount" id="total_amount" class="form-control" placeholder="TOTAL AMOUNT" value="<?php echo $amount ?>" readonly="readonly">
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="row">
                     <div class="col-md-12">
                        <div class="col-sm-6" id="product-wapper">
                           <table class="table table-bordered table-responsive">
                           <thead>
                              <tr>
                                 <th class="text-center" width="10">#</th>
                                 <th class="text-left">ACCOUNT NAME</th>
                                 <th class="text-right" width="150">AMOUNT</th>
                              </tr>
                           </thead>
                           <tbody>
                              <?php $tmp_cnt = 0; ?>
                                 <?php if(isset($detail) && count($detail) > 0) { ?>
                                 <?php foreach ($detail as $key => $detail_data) { ?>
                                 <tr>
                                    <td>
                                       <a href="javascript:;" class="btn red btn-block remove-me cutome-action-btn" style="display: <?php echo ($tmp_row_count == $last_med) ? 'block' : 'none'; ?>;"><i class="fa fa-minus"></i></a>
                                    </td>
                                    <td>
                                       <input type="text" name="product[<?php echo $key ?>][account_name]" class="add-more-table form-control account-name top" placeholder="SEARCH BY ACCOUNT NAME" data-count="<?php echo $key;?>" value="<?php echo $detail_data['account_name']?>">

                                       <input type="hidden" name="product[<?php echo $key ?>][account_id]" class="form-control top add-more-table account-id" readonly="readonly" tabindex="-1" value="<?php echo $detail_data['account_id']?>">

                                       <input type="hidden" name="product[<?php echo $key ?>][account_code]" class="form-control top add-more-table account-code" readonly="readonly" tabindex="-1" value="<?php echo $detail_data['account_code']?>">
                                    </td>
                                    <td><input type="text" name="product[<?php echo $key ?>][amount]" class="form-control top add-more-table amount number" value="<?php echo $detail_data['amount']?>"></td>
                                 </tr>
                                 <?php $tmp_cnt++; ?>
                                 <?php } ?>
                                 <?php } ?>
                                 <?php
                                    $tmp_for_loop = ( $tmp_cnt < 5 ) ? 5 : ($tmp_cnt + 1);
                                    $last_med = $tmp_for_loop - 1;
                                    ?>
                                 <?php for ($tmp_row_count = $tmp_cnt; $tmp_row_count < $tmp_for_loop; $tmp_row_count++) { ?>
                                 <tr>
                                    <td>
                                       <a href="javascript:;" class="btn green btn-block add-more cutome-action-btn" style="display: <?php echo ($tmp_row_count == $last_med) ? 'block' : 'none'; ?>"><i class="fa fa-plus"></i></a>
                                       <a href="javascript:;" class="btn red btn-block remove-me cutome-action-btn" style="display: <?php echo ($tmp_row_count == $last_med) ? 'none' : 'block'; ?>;"><i class="fa fa-minus"></i></a>
                                    </td>
                                    <td>
                                       <input type="text" name="product[<?php echo $tmp_row_count ?>][account_name]" class="add-more-table form-control account-name top" placeholder="SEARCH BY ACCOUNT NAME" data-count="<?php echo $tmp_row_count;?>">

                                       <input type="hidden" name="product[<?php echo $tmp_row_count ?>][account_id]" class="form-control top add-more-table account-id" readonly tabindex="-1">

                                       <input type="hidden" name="product[<?php echo $tmp_row_count ?>][account_code]" class="form-control top add-more-table account-code" readonly tabindex="-1">
                                    </td>
                                    <td><input type="text" name="product[<?php echo $tmp_row_count ?>][amount]" class="form-control top add-more-table amount number" readonly></td>
                                 </tr>
                                 <?php }  ?>
                           </tbody>
                        </table>
                        </div>
                     </div>
                  </div>
                  <div class="row">
                     <div class="col-md-12">
                        <div class="col-sm-6">
                           <div class="form-group">
                              <label class="capital">REMARK</label>
                              <textarea class="form-control" style="height:100px !important" name="remark" id="remark"><?php echo $remark?></textarea>
                           </div>
                        </div>
                     </div>
                  </div>
                  <hr>
                  <div class="row text-center">
                     <input type="hidden" name="id" class="form-control top add-more-table" value="<?php echo $id?>">
                     <button id="btn" class="btn btn-primary ajax-submit capital" type="submit"> Save & List</button>
                     <a href="index.php?page=bank_payment/list.php" class="btn btn-danger capital"> Cancel</a>
                  </div>
               </form>
            </div>
         </div>
      </div>
   </div>
</section>
<div id="product-template" style="display:none;">
  <table>
    <tr>
      <td>
        <a href="javascript:;" class="btn green btn-block add-more" style="display: block;"><i class="fa fa-plus"></i></a>
        <a href="javascript:;" class="btn red btn-block remove-me" style="display: none;"><i class="fa fa-minus"></i></a>
      </td>

      <td>
         <input type="text" name="product[%i%][account_name]" class="add-more-table form-control account-name top" placeholder="SEARCH BY ACCOUNT NAME" data-count="%i%">

         <input type="hidden" name="product[%i%][account_id]" class="form-control top add-more-table account-id" readonly tabindex="-1">

         <input type="hidden" name="product[%i%][account_code]" class="form-control top add-more-table account-code" readonly tabindex="-1">
      </td>

      <td><input type="text" name="product[%i%][amount]" class="form-control top add-more-table amount number" readonly></td>
    </tr>
  </table>
</div>
<script type="text/javascript">
jQuery(document).ready(function() {
   var $length = 0;
   productAutoComplete();
   jQuery(document).on('click', '.add-more', function(e) {
      $length = jQuery('#product-wapper').find('table tbody tr').length;
      var $clone = jQuery('#product-template table tr').clone();
      $clone.find('input').each(function() {
        this.name = this.name.replace('[%i%]', '[' + $length + ']');
      });
      $clone.find('.account-name').attr('data-count', $length);
      jQuery('#product-wapper table tbody').append($clone);
      productAutoComplete();
      jQuery('#product-wapper table tbody').find('.remove-me').show();
      jQuery('#product-wapper table tbody').find('.add-more').hide();
      jQuery('#product-wapper table tbody').find('.remove-me:last').hide();
      jQuery('#product-wapper table tbody').find('.add-more:last').show();
   });

   jQuery('#bank').select2();
   jQuery('#account_name').select2();
   jQuery('#transaction_type').select2();
   jQuery(document).on('change', "#bank", function() {
      getBankBookBalance();
   });

   jQuery(document).on('change', "#account_name", function() {
      getAccountBalance();
      SameAccount();
   });

   jQuery(document).on('focusout', "#product-wapper .amount", function() {
      calculateFinalAmount();
   });

   jQuery(document).on('click', '.remove-me', function(e) {
      e.preventDefault();
      jQuery(this).closest('tr').remove();
      calculateFinalAmount();
   });   
});

function getBankBookBalance(ele){
   var bank_book  = jQuery('#bank').val();
   $.ajax({
      'type': 'POST',
      'url' : 'bank_payment/closing_balance.php?p1=bank_book',
      'data': {
         'bank_book' : bank_book
      },
      dataType: 'JSON',
      success: function (data) {
         if (data != '') {
            jQuery('#balance-detail-wapper').find('.bank_book_balance_amount span').html(data.opeing);
            jQuery('#balance-detail-wapper').find('.bank_book_balance_flag span').html(data.flag);
         }
      }
   });
}

function getAccountBalance(ele){
  var account_id  = jQuery('#account_name').val();
  $.ajax({
    'type': 'POST',
    'url': 'bank_payment/closing_balance.php?p1=account_book',
    'data': {
      'account_id' : account_id
    },
    dataType: 'JSON',
    success: function (data) {
      if (data != '') {
        jQuery('#balance-detail-wapper').find('.account_balance_amount span').html(data.opeing);
        jQuery('#balance-detail-wapper').find('.account_balance_flag span').html(data.flag);
        
      }
    }
  });
}

function SameAccount() {
   var bank_book  = jQuery('#bank option:selected').text();
   var account_name  = jQuery('#account_name option:selected').text();
   if(bank_book == account_name){
      showNotification('Alert', 'SAME ACCOUNT DETECT', 'error');
      jQuery('#account_name').val('').trigger('change');
   }
}

function productAutoComplete() {
   jQuery( ".account-name" ).autocomplete({
      position: { my: "left bottom", at: "left top", collision: "flip" },
      source: function( request, response ) {
         $.ajax({
            url: "bank_payment/get_account.php",
            type: 'post',
            dataType: "json",
            data: {
              search: request.term
            },
            success: function( data ) {
              response( data );
            }
         });
      },
      select: function (event, ui) {
         var $parent = jQuery(this).parents('tr');
         var $i = jQuery(this).attr('data-count');
         $checkpoint = false;
         $checkpoint = CheckDuplicateRow(ui.item.ac_name, ui.item.id);
         if( $checkpoint ) {
            $parent.find('.account-name').val(ui.item.ac_name);
            $parent.find('.account-id').val(ui.item.id);
            $parent.find('.account-code').val(ui.item.act_code);
            $parent.find('.amount').removeAttr("readonly", "readonly");
         }else{
            var $this = jQuery(this);
            setTimeout(function(){
               $this.focus();
               $this.select();
            }, 100);
         }
         return false;
      }
   }).each(function() {
       $(this).autocomplete( 'instance' )._renderItem = function( ul, item ) {
          return $( "<li>" )
             .append( "<a><span>" + item.ac_name + '</span></a>' )
             .appendTo( ul );
        };
   });
}

function CheckDuplicateRow(lr_no){
   var $container = jQuery('#product-wapper');
   var $check = true;
   jQuery.each($container.find('tbody tr'), function(i, v){
      var $tmp_data_count     = jQuery(v).find('.account-name').attr('data-count');
      var $tmp_bill_no        = jQuery('input[name="product['+ $tmp_data_count +'][account_name]"]').val();
      if( $tmp_bill_no == lr_no) {
        $check = false;
        return false;
      }
   });
   if( $check ) {
      return true;
   } else {
      showNotification('Alert', 'ALREADY EXISTS ABOVE...', 'error');
      return false;
  }
}

function calculateFinalAmount() {
   var $product_wapper  = jQuery('#product-wapper').find('table tbody tr');
   var $total_amount = 0;
   $product_wapper.each(function(i, v) {
      $amount  = parseFloat(jQuery(v).find('.amount').val());
      if ($amount == '' || $amount == undefined || isNaN($amount)) {
        $amount = 0;
      }
      $total_amount += $amount;
   });

   jQuery('#total_amount').val($total_amount.toFixed(2));
}
</script>